/*  Copyright 2005 Guillaume Duhamel
	Copyright 2005-2006 Theo Berkau
	Copyright 2008 Filipe Azevedo
	Copyright 2010 freakdave

	This file is part of Yabause.

	Yabause is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Yabause is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Yabause; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
*/
#pragma optimize( "", on )
#ifdef HAVE_LIBSDL

#include <SDL.h>
#include <SDL_main.h>
#include "SDL_joystick.h"
#include "../debug.h"
#include "persdlx.h"
#include "../peripheral.h"
#include "../vdp2.h"

#define SDL_MAX_AXIS_VALUE 0x110000
#define SDL_MIN_AXIS_VALUE 0x100000
#define SDL_MEDIUM_AXIS_VALUE (int)(32768 / 2)
#define SDL_BUTTON_PRESSED 1
#define SDL_BUTTON_RELEASED 0

#define THRESHOLD 18000

int PERSDLXInit(void);
void PERSDLXDeInit(void);
int PERSDLXHandleEvents(void);


PerInterface_struct PERSDLX = {
PERCORE_SDLX,
"SDL XBOX Joystick Interface",
PERSDLXInit,
PERSDLXDeInit,
PERSDLXHandleEvents,
};

static PerPad_struct *pad1;


SDL_Joystick* CONTROLLER;

Sint16 ABUTTON, BBUTTON, XBUTTON,  YBUTTON, WHITEBUTTON, BLACKBUTTON;
Sint16 RTRIGGER, LTRIGGER, STARTBUTTON, BACKBUTTON;
Sint16 RSTICK, LSTICK;//thumbsticks
Sint16 LJOYX, LJOYY; //axes
Sint16 RJOYX, RJOYY;//sticks
Sint16 DPAD;//dpad
//Sint16 THRESHOLD;// = 18000 deadzone
//Uint8 *KEYS;//keyboard


//////////////////////////////////////////////////////////////////////////////

static INLINE int PERSDLXInit(void) {
	
	// init joysticks
	if ( SDL_InitSubSystem( SDL_INIT_JOYSTICK ) == -1 )
	{
		return -1;
	}
	
	if(SDL_NumJoysticks())
	{
		CONTROLLER = SDL_JoystickOpen(0); //Open controller 1
		SDL_JoystickEventState(SDL_ENABLE); //Enable event stuff for our controller
	}
		
	PerPortReset();
    pad1 = PerPadAdd(&PORTDATA1);

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

static INLINE void PERSDLXDeInit(void) {
	// close joysticks
	SDL_JoystickClose( CONTROLLER );
				
	// close sdl joysticks
	SDL_QuitSubSystem( SDL_INIT_JOYSTICK );
}

//////////////////////////////////////////////////////////////////////////////


static INLINE int PERSDLXHandleEvents(void) {
	
	//Pump our event queue
	SDL_PumpEvents();

	//Get keyboard changes
	//KEYS = SDL_GetKeyState(NULL);

	//manual refresh of the gamepad
	SDL_JoystickUpdate();

	//DPAD
	DPAD = SDL_JoystickGetHat(CONTROLLER, 0);

	//AXES
	LJOYX = SDL_JoystickGetAxis(CONTROLLER, 0);
	LJOYY = SDL_JoystickGetAxis(CONTROLLER, 1);

	RJOYX = SDL_JoystickGetAxis(CONTROLLER,2);
	RJOYY = SDL_JoystickGetAxis(CONTROLLER,3);
	
	//BUTTONS
	ABUTTON = SDL_JoystickGetButton(CONTROLLER, 0); //Get A-Button(0)
	BBUTTON = SDL_JoystickGetButton(CONTROLLER, 1);
	XBUTTON = SDL_JoystickGetButton(CONTROLLER,2);
	YBUTTON = SDL_JoystickGetButton(CONTROLLER,3);
	BLACKBUTTON = SDL_JoystickGetButton(CONTROLLER, 4); //Black Button
	WHITEBUTTON = SDL_JoystickGetButton(CONTROLLER, 5);
	LTRIGGER = SDL_JoystickGetButton(CONTROLLER,6);
	RTRIGGER = SDL_JoystickGetButton(CONTROLLER,7);
	BACKBUTTON = SDL_JoystickGetButton(CONTROLLER, 9); //Get BACK-Button(9)
	STARTBUTTON = SDL_JoystickGetButton(CONTROLLER,8);
	LSTICK = SDL_JoystickGetButton(CONTROLLER,10);
	RSTICK = SDL_JoystickGetButton(CONTROLLER,11);


	//DPAD UP
	if(DPAD == SDL_HAT_UP || LJOYY < -THRESHOLD){
		*pad1->padbits &= 0xEF;
	}else{
		*pad1->padbits |= ~0xEF;
	}

	//DPAD DOWN
	if(DPAD == SDL_HAT_DOWN || LJOYY > THRESHOLD){
		*pad1->padbits &= 0xDF;
	}else{
		*pad1->padbits |= ~0xDF;
	}

	//DPAD RIGHT
	if(DPAD == SDL_HAT_RIGHT || LJOYX > THRESHOLD){
		*pad1->padbits &= 0x7F;
	}else{
		*pad1->padbits |= ~0x7F;
	}

	//DPAD LEFT
	if(DPAD == SDL_HAT_LEFT || LJOYX < -THRESHOLD){
		*pad1->padbits &= 0xBF;
	}else{
		*pad1->padbits |= ~0xBF;
	}

	//START BUTTON
	if(STARTBUTTON){
		*pad1->padbits &= 0xF7;
	}else{
		*pad1->padbits |= ~0xF7;
	}

	//ABUTTON
	if(ABUTTON){
	*pad1->padbits &= 0xFB;
	}else{
	*pad1->padbits |= ~0xFB;
	}

	//BBUTTON
	if(BBUTTON){
	*pad1->padbits &= 0xFE;
	}else{
	*pad1->padbits |= ~0xFE;
	}

	//XBUTTON
	if(XBUTTON){
	*(pad1->padbits + 1) &= 0xBF;
	}else{
	*(pad1->padbits + 1) |= ~0xBF;
	}

	//YBUTTON
	if(YBUTTON){
	*(pad1->padbits + 1) &= 0xDF;
	}else{
	*(pad1->padbits + 1) |= ~0xDF;
	}

	//WHITEBUTTON(C-Button)
	if(WHITEBUTTON){
	*pad1->padbits &= 0xFD;
	}else{
	*pad1->padbits |= ~0xFD;
	}

	//BLACKBUTTON(Z-Button)
	if(BLACKBUTTON){
	*(pad1->padbits + 1) &= 0xEF;
	}else{
	*(pad1->padbits + 1) |= ~0xEF;
	}

	//RTRIGGER
	if(RTRIGGER){
	*(pad1->padbits + 1) &= 0x7F;
	}else{
	*(pad1->padbits + 1) |= ~0x7F;
	}

	//LTRIGGER
	if(LTRIGGER){
	*(pad1->padbits + 1) &= 0xF7;
	}else{
	*(pad1->padbits + 1) |= ~0xF7;
	}

	//Reset the YabauseX
	if(LTRIGGER && RTRIGGER && BLACKBUTTON){
		 YabauseResetButton();
	}

	//Return to Dashboard
	if(LTRIGGER && RTRIGGER && BLACKBUTTON && WHITEBUTTON && BACKBUTTON && STARTBUTTON)
	{
		LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
        XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
	}

	//Toggle debug output
	if(RSTICK)
	{
		ToggleFPS();
	}
	
	// execute yabause
	if ( YabauseExec() != 0 )
	{
		return -1;
	}
	
	// return success
	return 0;
}



#endif